import SearchBox, { searchColumns } from '~/components/search-box';
import { Button, message, Modal, Table, Tag } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { PlusOutlined } from '@ant-design/icons';
import { useNavigate } from 'react-router-dom';
import { PilotTrainAPI } from '~/api';
import { useEffect, useState } from 'react';
import { InterDataType, PaginationProps } from '~/api/interface';
import { listOrgPageType } from '~/api/interface/pilotTrainType';

//机构列表返回类型
type institutionListType = InterDataType<listOrgPageType>['list'];

const InstitutionsList = () => {
  const navigate = useNavigate();
  //培训类型下拉

  const search: searchColumns[] = [
    { label: '机构名称', name: '', placeholder: '请输入机构名称', type: 'input' },
    { label: '培训类型', name: '', placeholder: '请选择培训类型', type: 'select', options: [] },
    { label: '选择日期', name: '', placeholder: '请选择日期', type: 'rangePicker', options: [] },
  ];
  const tableColumns: ColumnsType<institutionListType[0]> = [
    {
      title: '序号',
      align: 'center',
      render: (_text: string, _record, index: number) =>
        (pagination.pageNo - 1) * pagination.pageSize + index + 1,
    },
    {
      title: '机构名称',
      align: 'center',
      dataIndex: 'name',
    },
    {
      title: '培训类型',
      align: 'center',
      render: (_text: string, record) =>
        record.programsDOList.map((v) => <Tag key={v.id}>{v.typeName}</Tag>),
      width: '20%',
    },
    {
      title: '创建日期',
      dataIndex: 'createTime',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
      render: (_text: string, record) => (
        <>
          <Button type='link' onClick={() => editInstitutionsClick(record)}>
            编辑
          </Button>
          <Button type='link' danger onClick={() => deleteInstitutionsClick(record)}>
            删除
          </Button>
        </>
      ),
    },
  ];
  const [tableData, setTableData] = useState<institutionListType>([]);
  const [pagination, setPagination] = useState<PaginationProps & { totalCount: number }>({
    pageNo: 1,
    pageSize: 10,
    totalCount: 0,
  });

  const toAddInstitutions = () => {
    navigate('/pilotTraining/institutionsList/add');
  };
  //机构列表
  const getListOrgPage = () => {
    PilotTrainAPI.getListOrgPage({ pageNo: pagination.pageNo, pageSize: pagination.pageSize }).then(
      ({ result }) => {
        setTableData(result.list || []);
        pagination.totalCount = result.totalCount;
        setPagination(pagination);
      },
    );
  };
  //分页-监听
  const paginationChange = (pageNo: number, pageSize: number) => {
    pagination.pageNo = pageNo;
    pagination.pageSize = pageSize;
    getListOrgPage();
  };
  //机构删除
  const deleteInstitutionsClick = (record: institutionListType[0]) => {
    Modal.confirm({
      title: '删除机构',
      content: '确认删除该机构吗？',
      onOk: () => {
        PilotTrainAPI.removeOrg({ id: record.id }).then(({ code }) => {
          if (code === '200') {
            message.success('删除成功');
            if (pagination.pageNo !== 1 && tableData.length === 1) {
              pagination.pageNo -= 1;
            }
            getListOrgPage();
          }
        });
      },
    });
  };
  //机构编辑
  const editInstitutionsClick = (record: institutionListType[0]) => {
    navigate({ pathname: '/pilotTraining/institutionsList/edit', search: `id=${record.id}` });
  };
  useEffect(() => {
    getListOrgPage();
  }, []);
  return (
    <div className='institutions-list'>
      <SearchBox
        search={search}
        child={
          <Button icon={<PlusOutlined />} type='primary' onClick={toAddInstitutions}>
            新增
          </Button>
        }
      />
      <Table
        bordered
        columns={tableColumns}
        dataSource={tableData}
        pagination={{
          total: pagination.totalCount,
          pageSize: pagination.pageSize,
          current: pagination.pageNo,
          showSizeChanger: true,
          showQuickJumper: true,
          onChange: (page: number, pageSize: number) => paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
      />
    </div>
  );
};
export default InstitutionsList;
